/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.system;

import com.ibm.hsc.ccfw.pa.domain.PowerAnalysisDomain;
import com.ibm.hsc.ccfw.pa.system.PIBpa;
import com.ibm.hsc.ccfw.pa.system.PIBpcFsp;
import com.ibm.hsc.ccfw.pa.system.PICecFsp;
import com.ibm.hsc.ccfw.pa.system.PIFsp;
import com.ibm.hsc.ccfw.pa.system.PIMachineSystem;
import com.ibm.hsc.ccfw.pa.util.PAHscEventHandler;
import com.ibm.hsc.ccfw.pa.util.PAHscEventListener;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.PIDumpEvent;
import com.ibm.hwmca.p.pa.event.PelDataEvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystemMonitor;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.UnsignedInt8;

public class PIFspMonitor
extends RemoteMachineSystemMonitor
implements PAHscEventListener,
RemoteSystemStateListener {
    private static final String TRACE_MASKT = "PPAFSPMT";
    private static final String TRACE_MASKF = "PPAFSPMF";
    private static final String TRACE_MASKD = "PPAFSPMD";
    public static final String CLASS_NAME = "com.ibm.hsc.ccfw.pa.system.PIFspMonitor";
    private static final String MONITOR_CFGMAP_KEY = "PIFspMonitorCfgMap";
    private PAHscEventHandler heHandler = null;
    private static final String CAGE_CIM_CLASS = "IBMHSC_Cage";
    private static final int PEL_EVENT_LOGID_IDX = 0;
    private static final int PEL_EVENT_LOCCODE_IDX = 1;

    public PIFspMonitor(Map map) {
        super(map);
        Trace.trace((String)TRACE_MASKD, (Object)"--> ctor");
        this.heHandler = PAHscEventHandler.buildHandler(this, map);
        Trace.trace((String)TRACE_MASKD, (Object)"<-- ctor");
    }

    protected String getMonitorCfgMapKey() {
        return MONITOR_CFGMAP_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Trace.trace((String)TRACE_MASKD, (Object)"--> start");
        PIBpcFsp pIBpcFsp = new PIBpcFsp();
        Set set = this.rsm.getLiveSystems(((Object)((Object)pIBpcFsp)).getClass());
        PICecFsp pICecFsp = new PICecFsp();
        Set set2 = this.rsm.getLiveSystems(((Object)((Object)pICecFsp)).getClass());
        Set set3 = null;
        Object object = this.setLock;
        synchronized (object) {
            this.systemSet = new HashSet();
            this.systemSet.addAll(set);
            this.systemSet.addAll(set2);
            this.buildCommunicationMap(this.systemSet);
            set3 = (Set)((HashSet)this.systemSet).clone();
        }
        this.synchronizeSystems(set3);
        this.heHandler.addSubscription(301, pIBpcFsp.getCIMClass());
        this.heHandler.addSubscription(302, pIBpcFsp.getCIMClass());
        this.heHandler.addSubscription(301, pICecFsp.getCIMClass());
        this.heHandler.addSubscription(302, pICecFsp.getCIMClass());
        this.heHandler.addSubscription(1, CAGE_CIM_CLASS);
        Trace.trace((String)TRACE_MASKD, (Object)"<-- start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteSystemStateChanged(RemoteSystemStateEvent remoteSystemStateEvent) {
        RemoteSystem remoteSystem = remoteSystemStateEvent.getRemoteSystem();
        if (!(remoteSystem instanceof PIFsp)) {
            return;
        }
        Object object = this.setLock;
        synchronized (object) {
            PowerAnalysisDomain powerAnalysisDomain;
            PowerAnalysisDomain powerAnalysisDomain2;
            boolean bl = false;
            if (remoteSystem instanceof PICecFsp && remoteSystemStateEvent.getState() == "Change") {
                bl = (Boolean)this.communicationMap.get(remoteSystem.getUniqueKey());
            }
            super.remoteSystemStateChanged(remoteSystemStateEvent);
            if (remoteSystem instanceof PICecFsp && remoteSystemStateEvent.getState() == "Change" && !bl && remoteSystem.canCommunicate() && (powerAnalysisDomain2 = (PowerAnalysisDomain)(powerAnalysisDomain = new PowerAnalysisDomain()).getDomain((PICecFsp)remoteSystem)) != null) {
                powerAnalysisDomain2.beginSynchronization();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hscEventOccured(HSCEvent hSCEvent) {
        block18: {
            Trace.trace((String)TRACE_MASKD, (Object)"--> hscEventOccured");
            Trace.trace((String)TRACE_MASKD, (Object)("key: " + hSCEvent.getEventKey()));
            Trace.trace((String)TRACE_MASKD, (Object)("type: " + hSCEvent.getEventType()));
            try {
                Object object;
                Object object2;
                PIMachineSystem pIMachineSystem;
                int n = hSCEvent.getEventType();
                CIMInstance cIMInstance = (CIMInstance)hSCEvent.getNewObject();
                PIFsp pIFsp = null;
                if (cIMInstance.getClassName().equals("IBMHSC_Frame")) {
                    pIMachineSystem = new PIBpa(cIMInstance, true);
                    object2 = null;
                    if (n == 301) {
                        object = (Vector)hSCEvent.getOldObject();
                        object2 = (String)((Vector)object).get(1);
                    } else if (n == 302) {
                        object2 = (String)hSCEvent.getOldObject();
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)"<-- hscEventOccured: unknown event type - ignored");
                        return;
                    }
                    pIFsp = ((PIBpa)pIMachineSystem).getBpc((String)object2);
                } else if (cIMInstance.getClassName().equals("IBMHSC_ComputerSystem")) {
                    pIFsp = new PICecFsp(cIMInstance, true);
                } else {
                    if (cIMInstance.getClassName().equals(CAGE_CIM_CLASS)) {
                        this.handleCage(cIMInstance);
                        Trace.trace((String)TRACE_MASKF, (Object)"<-- hscEventOccured");
                        return;
                    }
                    Trace.trace((String)TRACE_MASKD, (Object)("<-- hscEventOccured: Non-FSP event discarded: " + cIMInstance.getClassName()));
                    return;
                }
                Trace.trace((String)TRACE_MASKD, (Object)("event received from FSP: " + pIFsp.getUniqueCIMKey()));
                pIMachineSystem = null;
                object2 = this.setLock;
                synchronized (object2) {
                    object = this.systemSet.iterator();
                    while (object.hasNext() && !(pIMachineSystem = (PIFsp)((Object)object.next())).equals((Object)pIFsp)) {
                    }
                }
                if (pIMachineSystem == null) {
                    Trace.trace((String)TRACE_MASKD, (Object)"<-- hscEventOccured: Event from unrecognized system - ignored");
                    return;
                }
                if (n == 301) {
                    object2 = (Vector)hSCEvent.getOldObject();
                    object = (Long)((Vector)object2).get(0);
                    Trace.trace((String)TRACE_MASKD, (Object)("event old (PEL ID): " + Long.toString((Long)object, 16)));
                    this.handlePELNotificationEvent((PIFsp)pIMachineSystem, (Long)object);
                    break block18;
                }
                if (n == 302) {
                    this.handleDumpNotificationEvent((PIFsp)pIMachineSystem);
                    break block18;
                }
                Trace.trace((String)TRACE_MASKD, (Object)"<-- hscEventOccured: unknown event type - ignored");
                return;
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"caught exception - event ignored");
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)"<-- hscEventOccured");
    }

    protected void handlePELNotificationEvent(PIFsp pIFsp, Long l) {
        Vector vector = pIFsp.getPELs(this.monitorCfgMap, true, l, true, pIFsp.getLastLogEntryID());
        if (vector.size() == 0) {
            Trace.trace((String)TRACE_MASKD, (Object)"no data retrieved");
            return;
        }
        Object var4_4 = null;
        PelDataEvent pelDataEvent = null;
        for (int i = vector.size() - 1; i >= 0; --i) {
            try {
                Trace.trace((String)TRACE_MASKD, (Object)("processing PEL " + (i + 1) + " of " + vector.size()));
                pelDataEvent = new PelDataEvent((Object)pIFsp);
                pelDataEvent.setSystem((PASystem)pIFsp);
                pelDataEvent.setData((Object)((byte[])vector.get(i)));
                Trace.trace((String)TRACE_MASKD, (Object)("logging PEL " + (i + 1) + " of " + vector.size() + " (leid=" + Integer.toHexString(pelDataEvent.getFipsLogID()) + ", plid=" + Integer.toHexString(pelDataEvent.getPlatformLogID()) + ")"));
                this.log((DistributedDataEvent)pelDataEvent);
                pIFsp.acknowledgePEL(new Long(Long.parseLong(Integer.toHexString(pelDataEvent.getFipsLogID()), 16)));
                continue;
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"caught exception - ignoring PEL.");
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)(" setting lastLeid=" + Long.toString(l, 16)));
        pIFsp.setLastLogEntryID(l);
        try {
            this.rsm.changeLiveSystem((RemoteSystem)pIFsp);
        }
        catch (HException hException) {
            // empty catch block
        }
    }

    protected void handleDumpNotificationEvent(PIFsp pIFsp) {
        PIDumpEvent pIDumpEvent = new PIDumpEvent((Object)pIFsp);
        pIDumpEvent.setSystem((PASystem)pIFsp);
        Trace.trace((String)TRACE_MASKD, (Object)"logging dump notification");
        this.log((DistributedDataEvent)pIDumpEvent);
    }

    private void handleCage(CIMInstance cIMInstance) {
        Trace.trace((String)TRACE_MASKD, (Object)"--> handleCage");
        int n = 0;
        try {
            n = ((UnsignedInt8)PIHscUtil.getCIMAttribute(cIMInstance, "CageType").getValue()).intValue();
            Trace.trace((String)TRACE_MASKD, (Object)("CageType=" + n));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception caught obtaining CIM 'CageType' attribute");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            Trace.trace((String)TRACE_MASKD, (Object)"<-- handleCage");
            return;
        }
        switch (n) {
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            default: {
                Trace.trace((String)TRACE_MASKD, (Object)"<-- handleCage: non-CEC");
                return;
            }
        }
        String string = null;
        try {
            string = (String)PIHscUtil.getCIMAttribute(cIMInstance, "Name").getValue();
            Trace.trace((String)TRACE_MASKD, (Object)("Name=" + string));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception caught obtaining CIM 'Name' attribute");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            Trace.trace((String)TRACE_MASKD, (Object)"<-- handleCage");
            return;
        }
        String string2 = string.substring(string.indexOf("*") + 1);
        PIBpa pIBpa = new PIBpa();
        Set set = this.rsm.getLiveSystems(((Object)((Object)pIBpa)).getClass());
        Iterator iterator = null;
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            pIBpa = (PIBpa)((Object)iterator.next());
            bl = pIBpa.getMTMS().equals(string2);
        }
        if (!bl) {
            Trace.trace((String)TRACE_MASKD, (Object)"<-- handleCage: No PIBpa match found");
            return;
        }
        pIBpa.associateEncapsulatedCecs();
        boolean bl2 = false;
        PowerAnalysisDomain powerAnalysisDomain = new PowerAnalysisDomain();
        PowerAnalysisDomain powerAnalysisDomain2 = (PowerAnalysisDomain)powerAnalysisDomain.getDomain(string2);
        if (powerAnalysisDomain2 == null) {
            Trace.trace((String)TRACE_MASKD, (Object)"<-- handleCage: No power domain found?");
            return;
        }
        Set set2 = pIBpa.getAssociatedCECs();
        Iterator iterator2 = set2.iterator();
        PICecFsp pICecFsp = null;
        Set set3 = powerAnalysisDomain2.getMonitoredRemoteMachineSystems();
        Iterator iterator3 = null;
        RemoteMachineSystem remoteMachineSystem = null;
        boolean bl3 = false;
        while (iterator2.hasNext()) {
            pICecFsp = (PICecFsp)((Object)iterator2.next());
            iterator3 = set3.iterator();
            bl3 = false;
            while (iterator3.hasNext() && !bl3) {
                remoteMachineSystem = (RemoteMachineSystem)iterator3.next();
                bl3 = remoteMachineSystem.equals((Object)pICecFsp);
            }
            if (bl3) continue;
            Trace.trace((String)TRACE_MASKF, (Object)("Associating [" + pICecFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain2.getDomainId().getDID() + "]"));
            powerAnalysisDomain2.addMonitoredRemoteMachineSystem(pICecFsp);
            bl2 = true;
        }
        if (bl2) {
            powerAnalysisDomain2.beginSynchronization();
        }
        Trace.trace((String)TRACE_MASKD, (Object)"<-- handleCage");
    }

    public void log(DistributedDataEvent distributedDataEvent) {
        if (distributedDataEvent instanceof PelDataEvent && (((PelDataEvent)distributedDataEvent).isHidden() || !((PelDataEvent)distributedDataEvent).isExternal())) {
            Trace.trace((String)TRACE_MASKD, (Object)"Hidden or non-External Event - logging only");
            this.log(distributedDataEvent.getData(), distributedDataEvent.getSystem(), LogAttributes.INFO_LOG);
        } else if (distributedDataEvent instanceof PIDumpEvent) {
            Log log = new Log(96, 5, 0, "FSP Dump Notification", null, null, null, null);
            StringBuffer stringBuffer = new StringBuffer();
            XMLHelper.outToXML((Object)distributedDataEvent.getSystem(), (StringBuffer)stringBuffer, distributedDataEvent.getSystem().getClass());
            log.add((byte)4, (Object)stringBuffer.toString());
            log.log(LogAttributes.ERROR_LOG);
        } else {
            super.log(distributedDataEvent);
        }
    }
}

